// HelpDlg.cpp : implementation file
//

#include "stdafx.h"
#include "GrabIt.h"
#include "HelpDlg.h"
#include "About.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define HIMETRIC_INCH	2540

LPPICTURE	gpPicture;
BOOL g_UsePics = TRUE ;


/////////////////////////////////////////////////////////////////////////////
// CHelpDlg dialog


CHelpDlg::CHelpDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHelpDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHelpDlg)
	m_Help1 = _T("");
	m_Help2 = _T("");
	m_CheckStartup = FALSE;
	//}}AFX_DATA_INIT
}


void CHelpDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHelpDlg)
	DDX_Text(pDX, IDC_HELP1, m_Help1);
	DDX_Text(pDX, IDC_HELP2, m_Help2);
	DDX_Check(pDX, IDC_CHECKSTARTUP, m_CheckStartup);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHelpDlg, CDialog)
	//{{AFX_MSG_MAP(CHelpDlg)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BUTTONFAQ, OnButtonFAQ)
	ON_BN_CLICKED(IDC_BUTTONABOUT, OnButtonAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHelpDlg message handlers

BOOL CHelpDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here


	m_Help1 = "GrabIt works by \"secretly\" moving you to go and pick up an item.  " ;
	m_Help1 += "For items within 5 yards of you, they are grabbed immediately because " ;
	m_Help1 += "your character does not need to move to grab them.  Beyond 5 yards, " ;
	m_Help1 += "it is necessary to freeze (\"lag\") your game so the walking is not " ;
	m_Help1 += "interupted by another action.\r\n\r\n" ;

	m_Help1 += "The lag time is determined by how far from the item you are.  " ;
	m_Help1 += "After the lag, although you didn't move on your " ;
	m_Help1 += "screen, be careful because you are really where the grabbed item was.  " ;
	m_Help1 += "Moving will resync with b.net.\r\n\r\n" ;

	m_Help1 += "If an item drops outside of your specified range, but then you walk towards " ;
	m_Help1 += "it so that it comes within range, you will grab it.  It does not matter " ;
	m_Help1 += "how long ago it was dropped, GrabIt keeps track of all items." ;


	m_Help2 = "The row of pics are actually buttons.  Click a button to adjust the " ;
	m_Help2 += "filtering for that type of item.  " ;
	m_Help2 += "GrabIt allows you to select how long you are willing to lag in " ;
	m_Help2 += "order to grab certain items.  Set only the most precious items " ;
	m_Help2 += "to have far ranges.  " ;
	m_Help2 += "Choosing to grab a lower qualitity " ;
	m_Help2 += "item will auto- matically pick up higher quality items of the same type.  " ;
	m_Help2 += "Runes and gold have custom filters." ;

	UpdateData(FALSE) ;
	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


//obtained this code from http://support.microsoft.com/support/kb/articles/Q218/9/72.ASP?LN=EN-US&SD=gn&FR=0&qry=loadpic&rnk=1&src=DHCS_MSPSS_gn_SRCH&SPR=VCC
// This function loads a file into an IStream.
BOOL LoadPictureFile(LPCTSTR szFile)
{
	// open file
	HANDLE hFile = CreateFile(szFile, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
	if ( hFile == INVALID_HANDLE_VALUE) {

		// if we couldn't find the file, then check current dir (for idiot users!!!)
		//   this will also work if they previously did a find and change the current dir
		CString fileName = szFile ;
		fileName = fileName.Right( fileName.GetLength()) ;
		hFile = CreateFile( fileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
		if ( hFile == INVALID_HANDLE_VALUE) {


			// if we've been here before and said don't bother to search, then don't bother!
			if (!g_UsePics) {
				g_UsePics = FALSE ;
				return FALSE ;
			}

			CString prompt = "Missing a necessary graphic file: " + fileName + "\n  Would you like to search for it?" ;
			if ( AfxMessageBox( prompt, MB_YESNO) == IDYES) {

				OPENFILENAME ofn;
				::memset(&ofn, 0, sizeof(OPENFILENAME));
				ofn.lStructSize = sizeof(OPENFILENAME);
				TCHAR ptchFileName[MAX_PATH] ;
				strcpy( ptchFileName, fileName) ;
				ofn.lpstrFile = ptchFileName;
				ofn.nMaxFile = MAX_PATH;
				::GetOpenFileName(&ofn);

				hFile = CreateFile(ofn.lpstrFile, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
				if ( hFile == INVALID_HANDLE_VALUE)
					return FALSE ;

			// didn't want to search, so bail
			} else {
				g_UsePics = FALSE ;
				return FALSE ;
			}
		}
	}
	_ASSERTE(INVALID_HANDLE_VALUE != hFile);

	// get file size
	DWORD dwFileSize = GetFileSize(hFile, NULL);
	_ASSERTE(-1 != dwFileSize);

	LPVOID pvData = NULL;
	// alloc memory based on file size
	HGLOBAL hGlobal = GlobalAlloc(GMEM_MOVEABLE, dwFileSize);
	_ASSERTE(NULL != hGlobal);

	pvData = GlobalLock(hGlobal);
	_ASSERTE(NULL != pvData);

	DWORD dwBytesRead = 0;
	// read file and store in global memory
	BOOL bRead = ReadFile(hFile, pvData, dwFileSize, &dwBytesRead, NULL);
	_ASSERTE(FALSE != bRead);
	GlobalUnlock(hGlobal);
	CloseHandle(hFile);

	LPSTREAM pstm = NULL;
	// create IStream* from global memory
	HRESULT hr = CreateStreamOnHGlobal(hGlobal, TRUE, &pstm);
	_ASSERTE(SUCCEEDED(hr) && pstm);

	// Create IPicture from image file
	if (gpPicture)
		gpPicture->Release();
	hr = ::OleLoadPicture(pstm, dwFileSize, FALSE, IID_IPicture, (LPVOID *)&gpPicture);
	_ASSERTE(SUCCEEDED(hr) && gpPicture);	
	pstm->Release();

	return TRUE ;
}


void CHelpDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	////
	//// draw the background pic
	////

	long hmWidth;
	long hmHeight;
	int nWidth ;
	int nHeight	;
	RECT rc;
	GetClientRect(&rc);

	
	// load the background
	if (LoadPictureFile("bullseye5.jpg")) {

		// get width and height of picture
		gpPicture->get_Width(&hmWidth);
		gpPicture->get_Height(&hmHeight);

		// convert himetric to pixels
		nWidth	= MulDiv(hmWidth, GetDeviceCaps(dc.m_hDC, LOGPIXELSX), HIMETRIC_INCH) ;
		nHeight	= MulDiv(hmHeight, GetDeviceCaps(dc.m_hDC, LOGPIXELSY), HIMETRIC_INCH) ;

		// display picture using IPicture::Render
		gpPicture->Render( dc.m_hDC, 11, 11, nWidth, nHeight, 0, hmHeight, hmWidth, -hmHeight, &rc);
	}

	// Do not call CDialog::OnPaint() for painting messages
}

void CHelpDlg::OnButtonFAQ() 
{
	// TODO: Add your control notification handler code here
	
	ShellExecute(NULL,"open","readme.txt",NULL,NULL,SW_SHOWMAXIMIZED);
}

void CHelpDlg::OnButtonAbout() 
{
	// TODO: Add your control notification handler code here

	CAboutDlg dlg ;
	dlg.DoModal() ;
}
